using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Security.Cryptography;

//Celowo dodano w recepturze 11.8 w celu pokazania przeciania operatora == w obiektach Set
#pragma warning disable 1718 //Porwnanie z t sam zmienn; czy chciae wykona porwnanie z jak inn wartoci? 

namespace CSharpRecipes
{
	public class DataStructsAndAlgorithms
    {
        #region 11.1 Tworzenie skrtw dla typw danych
        public static void CreateHashCodeDataType()
		{
			SimpleClass simpleClass = new SimpleClass();

			Hashtable hashTable = new Hashtable();
			hashTable.Add(simpleClass, 100);

			Dictionary<SimpleClass, int> dict = new Dictionary<SimpleClass, int>();
			dict.Add(simpleClass, 100);
		}

		public class SimpleClass
		{
			private int x = 0;
			private int y = 0;

			public override int GetHashCode()
			{
				return(SimpleHash(x, y));
			}

			public int SimpleHash(params int[] values)
			{
				int hashCode = 0;
				if (values != null)
				{
					foreach (int val in values)
					{
						hashCode ^= val;
					}
				}

				return (hashCode);
			}
		}

		public int SimpleHash(params int[] values)
		{
			int hashCode = 0;
			if (values != null)
			{
				foreach (int val in values)
				{
					hashCode ^= val;
				}
			}

			return (hashCode);
		}

		public int FoldingHash(params long[] values)
		{
			int hashCode = 0;
			if (values != null)
			{
				int tempLowerVal = 0;
				int tempUpperVal = 0;
				foreach (long val in values)
				{
					tempLowerVal = (int)(val & 0x000000007FFFFFFF);
					tempUpperVal = (int)((val >> 32) & 0xFFFFFFFF);
					hashCode^= tempLowerVal ^ tempUpperVal;
				}
			}

			return (hashCode);
		}

		public int ContainedObjHash(params object[] values)
		{
			int hashCode = 0;
			if (values != null)
			{
				foreach (int val in values)
				{
					hashCode ^= val.GetHashCode();
				}
			}

			return (hashCode);
		}

		public int CryptoHash(string strValue)
		{
			int hashCode = 0;
			if (strValue != null)
			{
				byte[] encodedUnHashedString = 
					Encoding.Unicode.GetBytes(strValue);

				// Poniszy klucz naley zastpi wasn  
				// wartoci klucza
				byte[] Key = new byte[16] {1,122,3,11,65,7,9,45,42,98,
											  77,34,99,45,167,211};

				MACTripleDES hashingObj = new MACTripleDES(Key);
				byte[] code = 
					hashingObj.ComputeHash(encodedUnHashedString);

                // Wykorzystanie klasy BitConverter w celu pobrania 
                // pierwszych 4 bajtw, zoenia ich z ostatnimi 4 bajtami
                // i wykorzystania jako wartoci do obliczenia skrtu.

				hashCode = BitConverter.ToInt32(code,0);    
			}

			return (hashCode);
		}

		public int CryptoHash(long intValue)
		{
			int hashCode = 0;
			byte[] encodedUnHashedString = 
				Encoding.Unicode.GetBytes(intValue.ToString());

			SHA256Managed hashingObj = new SHA256Managed();
			byte[] code = hashingObj.ComputeHash(encodedUnHashedString);

            // Wykorzystanie klasy BitConverter w celu pobrania 
            // pierwszych 4 bajtw, zoenia ich z ostatnimi 4 bajtami
            // i wykorzystania jako wartoci do obliczenia skrtu.
            hashCode = BitConverter.ToInt32(code, 0);    

			return (hashCode);
		}

		public int ShiftAndAddHash (string strValue)
		{
			int hashCode = 0;
			long workHashCode = 0;

			if (strValue != null)
			{
				for (int counter=0; counter<strValue.Length; counter++)
				{
					workHashCode = (workHashCode << (counter % 4)) + 
						(int)strValue[counter];
				}
				workHashCode = workHashCode % (127);
			}
			hashCode = (int)workHashCode;

			return (hashCode);
		}

		public int CalcHash(short someShort, int someInt, long someLong,
			float someFloat, object someObject)
		{
			int hashCode = 7;
			hashCode = hashCode * 31 + (int)someShort;
			hashCode = hashCode * 31 + someInt;
			hashCode = hashCode * 31 + 
				(int)(someLong ^ (someLong >> 32));
			long someFloatToLong = (long)someFloat;
			hashCode = hashCode * 31 + 
				(int)(someFloatToLong ^ (someFloatToLong >> 32));

			if (someObject != null)
			{
				hashCode = hashCode * 31 + 
					someObject.GetHashCode();
			}

			return (hashCode);
		}

		public int ConcatStringGetHashCode(int[] someIntArray)
		{
			int hashCode = 0;
			StringBuilder hashString = new StringBuilder();

			if (someIntArray != null)
			{
				foreach (int i in someIntArray)
				{
					hashString.Append(i.ToString() + "^");
				}
			}
			hashCode = hashString.GetHashCode();

			return (hashCode);
		}



		#endregion

        #region 11.2 Tworzenie kolejek z priorytetami

        public static void CreatePriorityQueue()
        {
            // Utworzenie obiektu ArrayList zawierajcego komunikaty.
            List<string> msgs = new List<string>();
            msgs.Add("foo");
            msgs.Add("To jest duszy komunikat.");
            msgs.Add("bar");
            msgs.Add(@"Komunikat zawierajcy dziwne znaki
                   !@#$%^&*(  )_+=-0987654321~|}{[]\\;:?/>.<,");
            msgs.Add(@"<                                                                   
                      >");
            msgs.Add("<text>jeden</text><text>dwa</text><text>trzy</text>" +
                     "<text>cztery</text>");
            msgs.Add("");
            msgs.Add("1234567890");

            // Utworzenie kolejki priorytetowej z odpowiedni metod porwnujc.
            // Metoda porwnujca jest tworzona na bazie typu CompareLen
            // zdefiniowanego w punkcie Analiza.
            CompareLen<string> comparer = new CompareLen<string>();
            PriorityQueue<string> pqueue = new PriorityQueue<string>(comparer);

            // Dodanie wszystkich komunikatw z listy List do kolejki z priorytetami.
            foreach (string msg in msgs)
            {
                pqueue.Enqueue(msg);
            }

            // Wywietlenie komunikatw w kolejce w kolejnoci priorytetw.
            foreach (string msg in pqueue)
            {
                Console.WriteLine("Msg: " + msg);
            }
            Console.WriteLine("pqueue.IndexOf('bar') == " + pqueue.IndexOf("bar"));
            Console.WriteLine("pqueue.IndexOf('_bar_') == " + pqueue.IndexOf("_bar_"));

            Console.WriteLine("pqueue.Contains('bar') == " + pqueue.Contains("bar"));
            Console.WriteLine("pqueue.Contains('_bar_') == " +
                pqueue.Contains("_bar_"));

            Console.WriteLine("pqueue.BinarySearch('bar') == " +
                pqueue.BinarySearch("bar"));
            Console.WriteLine("pqueue.BinarySearch('_bar_') == " +
                              pqueue.BinarySearch("_bar_"));

            // Usuwanie komunikatw z kolejki poczwszy od najkrtszego.
            int currCount = pqueue.Count;
            for (int index = 0; index < currCount; index++)
            {
                // Aby usuwa komunikaty z kolejki poczwszy od najduszego, 
                // naley usun komentarze z poniszych wierszy i uj w komentarz 
                // wiersze, ktre usuwaj komunikaty z kolejki poczwszy od najkrtszego.
                //Console.WriteLine("pqueue.DequeueLargest(  ): " + 
                //                  pqueue.DequeueLargest(  ).ToString(  ));

                Console.WriteLine("pqueue.DequeueSmallest(  ): " +
                                   pqueue.DequeueSmallest().ToString());
            }
        }

		public class PriorityQueue<T> : IEnumerable, ICloneable
		{
			public PriorityQueue() {}
			public PriorityQueue(IComparer<T> icomparer)
			{
				specialComparer = icomparer;
			}


			protected List<T> internalQueue = new List<T>();
			protected IComparer<T> specialComparer = null;


			public int Count
			{
				get {return (internalQueue.Count);}
			}

			public void Clear()
			{
				internalQueue.Clear();
			}

			public object Clone()
			{
                // Utworzenie nowej kolejki z priorytetami i przypisanie jej tej samej metody porwnujcej.
				PriorityQueue<T> newPQ = new PriorityQueue<T>(specialComparer);
				newPQ.CopyTo(internalQueue.ToArray(),0);
				return newPQ;    
			}

			public int IndexOf(T item)
			{
				return (internalQueue.IndexOf(item));
			}

			public bool Contains(T item)
			{
				return (internalQueue.Contains(item));
			}

			public int BinarySearch(T item)
			{
				return (internalQueue.BinarySearch(item, specialComparer));
			}

			public bool Contains(T item, IComparer<T> specialComparer)
			{
				if (internalQueue.BinarySearch(item, specialComparer) >= 0)
				{
					return (true);
				}
				else
				{
					return (false);
				}
			}

			public void CopyTo(T[] array, int index)
			{
				internalQueue.CopyTo(array, index);
			}

			public virtual T[] ToArray()
			{
				return (internalQueue.ToArray());
			}

			public virtual void TrimExcess()
			{
				internalQueue.TrimExcess();
			}

			public void Enqueue(T item)
			{
				internalQueue.Add(item);
				internalQueue.Sort(specialComparer);
			}

			public T DequeueSmallest()
			{
				T item = internalQueue[0];
				internalQueue.RemoveAt(0);

				return (item);
			}

			public T DequeueLargest()
			{
				T item = internalQueue[internalQueue.Count - 1];
				internalQueue.RemoveAt(internalQueue.Count - 1);

				return (item);
			}

			public T PeekSmallest()
			{
				return (internalQueue[0]);
			}

			public T PeekLargest()
			{
				return (internalQueue[internalQueue.Count - 1]);
			}

			public IEnumerator GetEnumerator()
			{
				return (internalQueue.GetEnumerator());
			}
		}

		public class CompareLen<T> : IComparer<T>
            where T : IComparable<T>
        {
            public int Compare(T obj1, T obj2)
            {
                int result = 0;
                if (typeof(T) == typeof(string))
                {
                    result = CompareStrings(obj1 as string, obj2 as string);
                }
                else
                {
                    // Domylnie stosowany jest algorytm porwnywani typu obiektowego.
                    result = Comparer<T>.Default.Compare(obj1, obj2);
                }
                return (result);
            }

            private int CompareStrings(string str1, string str2)
            {
                if (str1 == null || str2 == null)
                {
                    throw (new ArgumentNullException(
                          "Porwnywane cigi znakw nie mog mie wartoci null."));
                }

                if (str1.Length == str2.Length)
                {
                    return (0);
                }
                else if (str1.Length > str2.Length)
                {
                    return (1);
                }
                else
                {
                    return (-1);
                }
            }

            public bool Equals(T item1, T item2)
            {
                if (item1 == null || item2 == null)
                {
                    throw (new ArgumentNullException(
                          "Porwnywane obiekty nie mog mie wartoci null."));
                }

                return (item1.Equals(item2));
            }

            public int GetHashCode(T obj)
            {
                if (obj == null)
                {
                    throw (new ArgumentNullException(
                          "Parametr obj nie moe mie wartoci null."));
                }

                return (obj.GetHashCode());
            }
        }

		#endregion

        #region 11.3 Tworzenie kolejek dwukierunkowych
        public static void CreatingAMoreVersatileQueue()
		{
            DblQueue<int> dqueue = new DblQueue<int>();

            // Waciwo Count powinna zwraca zero.
            Console.WriteLine("dqueue.Count: " + dqueue.Count);
            try
            {
                // Prba usunicia elementu z pustej kolejki.
                object o = dqueue.DequeueHead();
            }
            catch (Exception e)
            {
                Console.WriteLine("TEN WYJTEK ZOSTA ZGOSZONY SPECJALNIE!");
                Console.WriteLine(e.ToString());
                Console.WriteLine("TEN WYJTEK ZOSTA ZGOSZONY SPECJALNIE!");
            }

            // Dodawanie elementw do kolejki.
            dqueue.EnqueueHead(1);
            dqueue.EnqueueTail(2);
            dqueue.EnqueueHead(0);
            dqueue.EnqueueTail(3);

            dqueue.TrimExcess();

            // Wywietlenie wszystkich elementw w kolejce.
            foreach (int i in dqueue)
            {
                Console.WriteLine("Element w kolejce: " + i.ToString());
            }
            // Wyszukanie elementw w kolejce.
            Console.WriteLine("dqueue.Contains(1): " + dqueue.Contains(1));
            Console.WriteLine("dqueue.Contains(10): " + dqueue.Contains(10));

            // Odczytanie wartoci z pocztku i koca kolejki bez ich usuwania.
            Console.WriteLine("dqueue.PeekHead(): " + dqueue.PeekHead().ToString());
            Console.WriteLine("dqueue.PeekTail(): " + dqueue.PeekTail().ToString());

            // Skopiowanie kolejki do tablicy.
            Array arr = Array.CreateInstance(typeof(object), dqueue.Count);
            dqueue.CopyTo(arr, 0);
            foreach (object o in arr)
            {
                Console.WriteLine("Element w kolejce (CopyTo): " + o.ToString());
            }

            // Usunicie jednego elementu z pocztku kolejki i dwch z koca.
            Console.WriteLine("dqueue.DequeueHead(  ): " + dqueue.DequeueHead());
            Console.WriteLine("dqueue.DequeueTail(  ): " + dqueue.DequeueTail());
            Console.WriteLine("dqueue.DequeueTail(  ): " + dqueue.DequeueTail());

            // Wywietlenie liczby elementw oraz samych elementw
            Console.WriteLine("dqueue.Count: " + dqueue.Count);
            foreach (int i in dqueue)
            {
                Console.WriteLine("Element w kolejce: " + i.ToString());
            }
        }


		[Serializable]
		public class DblQueue<T> : ICollection, IEnumerable
		{
			public DblQueue() 
			{
				internalList = new List<T>();
			}

			public DblQueue(ICollection<T> coll) 
			{
				internalList = new List<T>(coll);
			}


			protected List<T> internalList = null;


			public virtual int Count 
			{
				get {return (internalList.Count);}
			}

			public virtual bool IsSynchronized 
			{
				get {return (false);}
			}

			public virtual object SyncRoot 
			{
				get {return (this);}
			}

			//public static DblQueue Synchronized(DblQueue dqueue)
			//{
			//    if (dqueue == null)
			//    {
			//        throw (new ArgumentNullException("dqueue"));
			//    }
			//    return (new SyncDeQueue(dqueue));
			//}

			public virtual void Clear()
			{
				internalList.Clear();
			}

			public virtual bool Contains(T obj)
			{
				return (internalList.Contains(obj));
			}

			public virtual void CopyTo(Array array, int index)
			{
				for (int cntr = 0; cntr < internalList.Count; cntr++)
				{
					array.SetValue((object)internalList[cntr], cntr);
				}
			}

			public virtual T DequeueHead()
			{
				T retObj = internalList[0];
				internalList.RemoveAt(0);
				return (retObj);
			}

			public virtual T DequeueTail()
			{
				T retObj = internalList[internalList.Count - 1];
				internalList.RemoveAt(internalList.Count - 1);
				return (retObj);            
			}

			public virtual void EnqueueHead(T obj)
			{
				internalList.Insert(0, obj);
			}

			public virtual void EnqueueTail(T obj)
			{
				internalList.Add(obj);
			}

			public virtual T PeekHead()
			{
				return (internalList[0]);
			}

			public virtual T PeekTail()
			{
				return (internalList[internalList.Count - 1]);
			}

			public virtual IEnumerator GetEnumerator()
			{
				return (internalList.GetEnumerator());
			}

			public virtual T[] ToArray()
			{
				return (internalList.ToArray());
			}

			public virtual void TrimExcess()
			{
				internalList.TrimExcess();
			}


			//// Nested Synchronized class
			//[Serializable]
			//public class SyncDeQueue : DblQueue
			//{
			//    public SyncDeQueue(DblQueue q) 
			//    {
			//        wrappedQ = q;
			//        root = q.SyncRoot;
			//    }

			//    private DblQueue wrappedQ = null;
			//    private object root = null;

			//    public override int Count 
			//    {
			//        get 
			//        {
			//            lock(this)
			//            {
			//                return (wrappedQ.Count);
			//            }
			//        }
			//    }

			//    public override bool IsSynchronized 
			//    {
			//        get {return (true);}
			//    }

			//    public override object SyncRoot 
			//    {
			//        get {return (root);}
			//    }

			//    public override void Clear()
			//    {
			//        lock(this)
			//        {
			//            wrappedQ.Clear();
			//        }
			//    }

			//    public override object Clone()
			//    {
			//        lock(this)
			//        {
			//            return (this.MemberwiseClone());
			//        }
			//    }

			//    public override bool Contains(object obj)
			//    {
			//        lock(this)
			//        {
			//            return (wrappedQ.Contains(obj));
			//        }
			//    }

			//    public override void CopyTo(Array array, int index)
			//    {
			//        lock(this)
			//        {
			//            wrappedQ.CopyTo(array, index);
			//        }
			//    }

			//    public override object DequeueHead()
			//    {
			//        lock(this)
			//        {
			//            return (wrappedQ.DequeueHead());
			//        }
			//    }

			//    public override void EnqueueHead(object obj)
			//    {
			//        lock(this)
			//        {
			//            wrappedQ.EnqueueHead(obj);
			//        }
			//    }

			//    public override object PeekHead()
			//    {
			//        lock(this)
			//        {
			//            return (wrappedQ.PeekHead());
			//        }
			//    }

			//    public override object DequeueTail()
			//    {
			//        lock(this)
			//        {
			//            return (wrappedQ.DequeueTail());
			//        }
			//    }

			//    public override void EnqueueTail(object obj)
			//    {
			//        lock(this)
			//        {
			//            wrappedQ.EnqueueTail(obj);
			//        }
			//    }

			//    public override object PeekTail()
			//    {
			//        lock(this)
			//        {
			//            return (wrappedQ.PeekTail());
			//        }
			//    }

			//    public override IEnumerator GetEnumerator()
			//    {
			//        lock(this)
			//        {
			//            return (wrappedQ.GetEnumerator());
			//        }
			//    }

			//    public override object[] ToArray()
			//    {
			//        lock(this)
			//        {
			//            return (wrappedQ.ToArray());
			//        }
			//    }

			//    public override void TrimToSize()
			//    {
			//        lock(this)
			//        {
			//            wrappedQ.TrimToSize();
			//        }
			//    }
			//}
		}

		#endregion

        #region 11.4 Sprawdzanie zrwnowaenia znakw lub cigw
        public static void DeterminingWhereCharStringNoBalance()
		{
			Balance balanceUtil = new Balance();

            // Cig znakw zawierajcy niezrwnowaony znak }. Niezrwnowaony znak jest ostatnim nawiasem klamrowym
            // w cigu.
            string unbalanced = @"{namespace Unbalanced
                            {
                                public class Tipsy
                                {
                                    public Tipsy()
                                    {
                                }}}}}
                            ";

            // Wykorzystanie rnych przecionych metod Check 
            // do wyszukiwania niezrwnowaonych znakw }.
            Console.WriteLine("Rwnowaga {}: " + 
				balanceUtil.Check(unbalanced, '{', '}'));
            Console.WriteLine("Rwnowaga {}: " + 
				balanceUtil.Check(unbalanced.ToCharArray(), '{', '}'));

            Console.WriteLine("Rwnowaga {}: " + 
				balanceUtil.Check(unbalanced.ToCharArray(), 
				new char[1] {'{'}, new char[1] {'}'}));
            Console.WriteLine("Rwnowaga {}: " + 
				balanceUtil.Check(unbalanced.ToCharArray(), 
				new char[1] {'{'}, new char[1] {'}'}));
		}

		public class Balance
		{
			public Balance() {}

			private Stack<int> bookMarks = new Stack<int>();

			public int Check(string source, char openChar, char closeChar)
			{
				return (Check(source.ToCharArray(), openChar, closeChar));
			}

			public int Check(char[] source, char openChar, char closeChar)
			{
				bookMarks.Clear();

				for (int index = 0; index < source.Length; index++)
				{
					if (source[index] == openChar)
					{
						bookMarks.Push(index);
					}
					else if (source[index] == closeChar)
					{
						if (bookMarks.Count <= 0)
						{
							return (index);
						}
						else
						{
							bookMarks.Pop();
						}
					}
				}

				if (bookMarks.Count > 0)
				{
					return ((int)bookMarks.Pop());
				}
				else
				{
					return (-1);
				}
			}        

			public int Check(string source, string openChars, string closeChars)
			{
				return (Check(source.ToCharArray(), openChars.ToCharArray(), 
					closeChars.ToCharArray()));
			}

			public int Check(char[] source, char[] openChars, char[] closeChars)
			{
				bookMarks.Clear();

				for (int index = 0; index < source.Length; index++)
				{
					if (source[index] == openChars[0])
					{
						if (CompareArrays(source, openChars, index))
						{
							bookMarks.Push(index);
						}
					}

					if (source[index] == closeChars[0])
					{
						if (CompareArrays(source, closeChars, index))
						{
							if (bookMarks.Count <= 0)
							{
								return (index);
							}
							else
							{
								bookMarks.Pop();
							}
						}
					}
				}

				if (bookMarks.Count > 0)
				{
					return ((int)bookMarks.Pop());
				}
				else
				{
					return (-1);
				}
			}

			public bool CompareArrays(char[] source, char[] targetChars, int startPos)
			{
				bool isEqual = true;

				for (int index = 0; index < targetChars.Length; index++)
				{
					if (targetChars[index] != source[startPos + index])
					{
						isEqual = false;
						break;
					}
				}

				return (isEqual);
			}    
		}


		#endregion

        #region	11.5 Tworzenie odwzorowania jeden do wielu
        public static void TestMultiMap()
		{
    string s = "foo";

    // Utworzenie obiektu Multimap i wypenienie go danymi.
    MultiMap<int, string> myMap = new MultiMap<int, string>(  );
    myMap.Add(0, "zero");
    myMap.Add(1, "jeden");
    myMap.Add(2, "dwa");
    myMap.Add(3, "trzy");
    myMap.Add(3, "zdublowane trzy");
    myMap.Add(3, "zdublowane trzy");
    myMap.Add(4, "null");
    myMap.Add(5, s);
    myMap.Add(6, s);

    // Wywietlenie zawartoci.
    foreach (KeyValuePair<int, List<string>> entry in myMap)
    {
        Console.Write("Indeks: " + entry.Key.ToString(  ) + "\tWarto: ");
        foreach (string str in myMap[entry.Key])
        {
            Console.Write(str + " : ");
        }
        Console.WriteLine(  );
    }

    // Uzyskanie wartoci za pomoc indeksatora.
    Console.WriteLine(  );
    Console.WriteLine("((ArrayList) myMap[3])[0]: " + myMap[3][0]);
    Console.WriteLine("((ArrayList) myMap[3])[1]: " + myMap[3][1]);

    // Dodanie elementw do obiektu MultiMap z wykorzystaniem obiektu List.
    List<string> testArray = new List<string>(  );
    testArray.Add("BAR");
    testArray.Add("BAZ");
    myMap[10] = testArray;
    myMap[10] = testArray;

    // Usunicie elementw z obiektu MultiMap.
    myMap.Remove(0);
    myMap.Remove(1);

    // wywietlenie zawartoci obiektu MultiMap.
    Console.WriteLine(  );
    Console.WriteLine("myMap.Count: " + myMap.Count);
    foreach (KeyValuePair<int, List<string>> entry in myMap)
    {
        Console.Write("entry.Key: " + entry.Key.ToString(  ) + 
                      "\tentry.Value(s): ");
        foreach (string str in myMap[entry.Key])
        {
            if (str == null)
            {
                Console.Write("null : ");
            }
            else
            {
                Console.Write(str + " : ");
            }
        }
        Console.WriteLine(  );
    }

    // Sprawdzenie, czy obiekt map zawiera indeks, czy warto.
    Console.WriteLine(  );
    Console.WriteLine("myMap.ContainsKey(2): " + myMap.ContainsKey(2));
    Console.WriteLine("myMap.ContainsValue(two): " + 
    myMap.ContainsValue("dwa"));

    Console.WriteLine("Zawiera indeks 2: " + myMap.ContainsKey(2));
    Console.WriteLine("Zawiera indeks 12: " + myMap.ContainsKey(12));

    Console.WriteLine("Zawiera warto dwa: " + myMap.ContainsValue("dwa"));
    Console.WriteLine("Zawiera warto BAR: " + myMap.ContainsValue("BAR"));

    // Usunicie wszystkich elementw z obiektu MultiMap.
    myMap.Clear(  );
}
/* ORIGINAL DATA
Key: 4	Value: 
Key: 5	Value: foo : 
Key: 6	Value: foo : 
Key: 0	Value: zero : 
Key: 1	Value: one : 
Key: 2	Value: two : 
Key: 3	Value: three : duplicate three : duplicate three : 

((ArrayList) myMap[3])[0]: three
((ArrayList) myMap[3])[1]: duplicate three

myMap.Count: 6
entry.Key: 2	entry.Value(s): two : 
entry.Key: 3	entry.Value(s): three : duplicate three : duplicate three : 
entry.Key: 4	entry.Value(s): 
entry.Key: 5	entry.Value(s): foo : 
entry.Key: 6	entry.Value(s): foo : 
entry.Key: 10	entry.Value(s): BAR : BAZ : 

myMap.ContainsKey(2): True
myMap.ContainsValue(two): True
*/

        public class MultiMap<T, U>		// T is the MultiMap key and U is the MultiMap value
        {
            private Dictionary<T, List<U>> map = new Dictionary<T, List<U>>();


            public List<U> this[T key]
            {
                get { return (map[key]); }
                set { map[key] = value; }
            }

            public void Add(T key, U item)
            {
                AddSingleMap(key, item);
            }

            public void Clear()
            {
                map.Clear();
            }

            public int Count
            {
                get { return (map.Count); }
            }

            public bool ContainsKey(T key)
            {
                return (map.ContainsKey(key));
            }

            public bool ContainsValue(U item)
            {
                if (item == null)
                {
                    foreach (KeyValuePair<T, List<U>> kvp in map)
                    {
                        if (((List<U>)kvp.Value).Count == 0)
                        {
                            return (true);
                        }
                    }

                    return (false);
                }
                else
                {
                    foreach (KeyValuePair<T, List<U>> kvp in map)
                    {
                        if (((List<U>)kvp.Value).Contains(item))
                        {
                            return (true);
                        }
                    }

                    return (false);
                }
            }

            public Dictionary<T, List<U>>.Enumerator GetEnumerator()
            {
                return (map.GetEnumerator());
            }

            public void Remove(T key)
            {
                RemoveSingleMap(key);
            }

            protected virtual void AddSingleMap(T key, U item)
            {
                // Wyszukiwanie indeksu w obiekcie map typu Hashtable.
                if (map.ContainsKey(key))
                {
                    // Dodanie wartoci do listy List obiektu map.
                    List<U> values = (List<U>)map[key];

                    // Dodanie wartoci do istniejcego indeksu.
                    values.Add(item);
                }
                else
                {
                    if (item == null)
                    {
                        // Utworzenie nowego indeksu i odwzorowanie go do pustej listy List.
                        map.Add(key, new List<U>());
                    }
                    else
                    {
                        List<U> values = new List<U>();
                        values.Add(item);

                        // Utworzenie nowego indeksu i odwzorowanie go do jego wartoci.
                        map.Add(key, values);
                    }
                }
            }

            protected virtual bool RemoveSingleMap(T key)
            {
                if (this.ContainsKey(key))
                {
                    // Usunicie indeksu z obiektu KeysTable.
                    return (map.Remove(key));
                }
                else
                {
                    throw (new ArgumentOutOfRangeException("key", key,
                            "Ten indeks nie istnieje w odwzorowaniu."));
                }
            }
        }

		#endregion

		#region 11.6 Tworzenie drzew binarnych	
		public static void TestBinaryTree()
		{
			BinaryTree<string> tree = new BinaryTree<string>("d");
			tree.AddNode("a");
			tree.AddNode("b");
			tree.AddNode("f");
			tree.AddNode("e");
			tree.AddNode("c");
			tree.AddNode("g");
    
			tree.Print();
			tree.Print();

			Console.WriteLine("tree.TreeSize: " + tree.TreeSize);            
			Console.WriteLine("tree.GetRoot().DepthFirstSearch(a).NumOfChildren: " + 
				tree.GetRoot().DepthFirstSearch("b").NumOfChildren);            
			Console.WriteLine("tree.GetRoot().DepthFirstSearch(a).NumOfChildren: " + 
				tree.GetRoot().DepthFirstSearch("a").NumOfChildren);            
			Console.WriteLine("tree.GetRoot().DepthFirstSearch(g).NumOfChildren: " + 
				tree.GetRoot().DepthFirstSearch("g").NumOfChildren);            

			Console.WriteLine("tree.SearchDepthFirst(a): " + 
				tree.SearchDepthFirst("a").Value.ToString());
			Console.WriteLine("tree.SearchDepthFirst(b): " + 
				tree.SearchDepthFirst("b").Value.ToString());
			Console.WriteLine("tree.SearchDepthFirst(c): " + 
				tree.SearchDepthFirst("c").Value.ToString());
			Console.WriteLine("tree.SearchDepthFirst(d): " + 
				tree.SearchDepthFirst("d").Value.ToString());
			Console.WriteLine("tree.SearchDepthFirst(e): " + 
				tree.SearchDepthFirst("e").Value.ToString());
			Console.WriteLine("tree.SearchDepthFirst(f): " + 
				tree.SearchDepthFirst("f").Value.ToString());

			tree.GetRoot().RemoveLeftNode();
			tree.Print();

			tree.GetRoot().RemoveRightNode();
			tree.Print();
		}
/*  ORIGINAL DATA
a
	Contains Left:  NULL
	Contains Right: b
b
	Contains Left:  NULL
	Contains Right: c
c
	Contains Left:  NULL
	Contains Right: NULL
d
	Contains Left: a
	Contains Right: f
e
	Contains Left:  NULL
	Contains Right: NULL
f
	Contains Left: e
	Contains Right: g
g
	Contains Left:  NULL
	Contains Right: NULL
a
	Contains Left:  NULL
	Contains Right: b
b
	Contains Left:  NULL
	Contains Right: c
c
	Contains Left:  NULL
	Contains Right: NULL
d
	Contains Left: a
	Contains Right: f
e
	Contains Left:  NULL
	Contains Right: NULL
f
	Contains Left: e
	Contains Right: g
g
	Contains Left:  NULL
	Contains Right: NULL
tree.TreeSize: 7
tree.GetRoot().DepthFirstSearch(a).NumOfChildren: 1
tree.GetRoot().DepthFirstSearch(a).NumOfChildren: 2
tree.GetRoot().DepthFirstSearch(g).NumOfChildren: 0
tree.SearchDepthFirst(a): a
tree.SearchDepthFirst(b): b
tree.SearchDepthFirst(c): c
tree.SearchDepthFirst(d): d
tree.SearchDepthFirst(e): e
tree.SearchDepthFirst(f): f
d
	Contains Left:  NULL
	Contains Right: f
e
	Contains Left:  NULL
	Contains Right: NULL
f
	Contains Left: e
	Contains Right: g
g
	Contains Left:  NULL
	Contains Right: NULL
d
	Contains Left:  NULL
	Contains Right: NULL
*/

		public static void TestManagedTreeWithNoBinaryTreeClass()
		{
			// Create the root node
			BinaryTreeNode<string> topLevel = new BinaryTreeNode<string>("d");

			// Create all nodes that will be added to the tree
			BinaryTreeNode<string> one = new BinaryTreeNode<string>("b");
			BinaryTreeNode<string> two = new BinaryTreeNode<string>("c");
			BinaryTreeNode<string> three = new BinaryTreeNode<string>("a");
			BinaryTreeNode<string> four = new BinaryTreeNode<string>("e");
			BinaryTreeNode<string> five = new BinaryTreeNode<string>("f");
			BinaryTreeNode<string> six = new BinaryTreeNode<string>("g");

			// Add nodes to tree through the root
			topLevel.AddNode(three);
			topLevel.AddNode(one);
			topLevel.AddNode(five);
			topLevel.AddNode(four);
			topLevel.AddNode(two);
			topLevel.AddNode(six);

			// Print the tree starting at the root node
			topLevel.PrintDepthFirst();

			// Print the tree starting at node Three
			three.PrintDepthFirst();

			// Display the number of child nodes of various nodes in the tree
			Console.WriteLine("topLevel.NumOfChildren: " + topLevel.NumOfChildren);
			Console.WriteLine("one.NumOfChildren: " + one.NumOfChildren);
			Console.WriteLine("three.NumOfChildren: " + three.NumOfChildren);
			Console.WriteLine("six.NumOfChildren: " + six.NumOfChildren);

			// Search the tree using the depth first searching method
			Console.WriteLine("topLevel.DepthFirstSearch(a): " +
					topLevel.DepthFirstSearch("a").Value.ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(b): " +
					topLevel.DepthFirstSearch("b").Value.ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(c): " +
					topLevel.DepthFirstSearch("c").Value.ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(d): " +
					topLevel.DepthFirstSearch("d").Value.ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(e): " +
					topLevel.DepthFirstSearch("e").Value.ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(f): " +
					topLevel.DepthFirstSearch("f").Value.ToString());

			// Remove the left child node from the root node and display the entire tree
			topLevel.RemoveLeftNode();
			topLevel.PrintDepthFirst();

			// Remove all nodes from the tree except for the root and display the tree
			topLevel.RemoveRightNode();
			topLevel.PrintDepthFirst();
		}
/*  ORIGINAL DATA
a
	Contains Left:  NULL
	Contains Right: b
b
	Contains Left:  NULL
	Contains Right: c
c
	Contains Left:  NULL
	Contains Right: NULL
d
	Contains Left: a
	Contains Right: f
e
	Contains Left:  NULL
	Contains Right: NULL
f
	Contains Left: e
	Contains Right: g
g
	Contains Left:  NULL
	Contains Right: NULL
a
	Contains Left:  NULL
	Contains Right: b
b
	Contains Left:  NULL
	Contains Right: c
c
	Contains Left:  NULL
	Contains Right: NULL
topLevel.NumOfChildren: 6
one.NumOfChildren: 1
three.NumOfChildren: 2
six.NumOfChildren: 0
topLevel.DepthFirstSearch(a): a
topLevel.DepthFirstSearch(b): b
topLevel.DepthFirstSearch(c): c
topLevel.DepthFirstSearch(d): d
topLevel.DepthFirstSearch(e): e
topLevel.DepthFirstSearch(f): f
d
	Contains Left:  NULL
	Contains Right: f
e
	Contains Left:  NULL
	Contains Right: NULL
f
	Contains Left: e
	Contains Right: g
g
	Contains Left:  NULL
	Contains Right: NULL
d
	Contains Left:  NULL
	Contains Right: NULL
	*/


		public class BinaryTree<T> 
			where T: IComparable<T>
		{
			public BinaryTree() {}

			public BinaryTree(T value, int index) 
			{
				BinaryTreeNode<T> node = new BinaryTreeNode<T>(value, index);
				root = node;
				counter = 1;
			}

			// Use this .ctor when you need to flatten this tree
			public BinaryTree(T value) 
			{
				BinaryTreeNode<T> node = new BinaryTreeNode<T>(value);
				root = node;
				counter = 1;
			}


            protected int counter = 0;                // Liczba wzw drzewa
            protected BinaryTreeNode<T> root = null;  // Wskanik do gwnego wza drzewa


			public void AddNode(T value, int index)
			{
				BinaryTreeNode<T> node = new BinaryTreeNode<T>(value, index);
				++counter;

				if (root == null)
				{
					root = node;
				}
				else
				{
					root.AddNode(node);
				}
			}

			// Use this method to add a node 
			//    when you need to flatten this tree
			public int AddNode(T value)
			{
				BinaryTreeNode<T> node = new BinaryTreeNode<T>(value);
				++counter;

				if (root == null)
				{
					root = node;
				}
				else
				{
					root.AddNode(node);
				}

				return (counter - 1);
			}

			public BinaryTreeNode<T> SearchDepthFirst(T value)
			{
				return (root.DepthFirstSearch(value));
			}

			public void Print()
			{
				root.PrintDepthFirst();
			}

			public BinaryTreeNode<T> GetRoot()
			{
				return (root);
			}

			public int TreeSize
			{
				get {return (counter);}
			}        
		}

		public class BinaryTreeNode<T>
			where T: IComparable<T>
		{
			public BinaryTreeNode() {}

			public BinaryTreeNode(T value)
			{
				nodeValue = value;
			}

			// These 2 ctors Added to allow tree to be flattened
			public BinaryTreeNode(int index) 
			{
				nodeIndex = index;
			}

			public BinaryTreeNode(T value, int index)
			{
				nodeValue = value;
				nodeIndex = index;
			}


			protected int nodeIndex = 0;         // Added to allow tree to be flattened
			protected T nodeValue = default(T);
			protected BinaryTreeNode<T> leftNode = null;     //  leftNode.Value < Value
			protected BinaryTreeNode<T> rightNode = null;    //  rightNode.Value >= Value


			public int NumOfChildren
			{
				get {return (CountChildren());}
			}

			public int CountChildren()
			{
				int currCount = 0;

				if (leftNode != null)
				{
					++currCount;
					currCount += leftNode.CountChildren();
				}

				if (rightNode != null)
				{
					++currCount;
					currCount += rightNode.CountChildren();
				}

				return (currCount);
			}


			public int Index
			{
				get {return (nodeIndex);}
			}

			public BinaryTreeNode<T> Left
			{
				get {return (leftNode);}
			}

			public BinaryTreeNode<T> Right
			{
				get {return (rightNode);}
			}

			public T Value 
			{
				get {return (nodeValue);}
			}

			public void AddNode(BinaryTreeNode<T> node)
			{
				if (node.nodeValue.CompareTo(nodeValue) < 0)
				{
					if (leftNode == null)
					{
						leftNode = node;
					}
					else
					{
						leftNode.AddNode(node);
					}
				}
				else if (node.nodeValue.CompareTo(nodeValue) >= 0)
				{
					if (rightNode == null)
					{
						rightNode = node;
					}
					else
					{
						rightNode.AddNode(node);
					}
				}
			}

			public bool AddUniqueNode(BinaryTreeNode<T> node)
			{
				bool isUnique = true;

				if (node.nodeValue.CompareTo(nodeValue) < 0)
				{
					if (leftNode == null)
					{
						leftNode = node;
					}
					else
					{
						leftNode.AddNode(node);
					}
				}
				else if (node.nodeValue.CompareTo(nodeValue) > 0)
				{
					if (rightNode == null)
					{
						rightNode = node;
					}
					else
					{
						rightNode.AddNode(node);
					}
				}
				else   //node.nodeValue.CompareTo(nodeValue) = 0
				{
					isUnique = false;
					// Could throw exception here as well...
				}

				return (isUnique);
			}

			public BinaryTreeNode<T> DepthFirstSearch(T targetObj)
			{
				// NOTE: foo.CompareTo(bar) == -1   -->   (foo < bar)
				BinaryTreeNode<T> retObj = null;
				int comparisonResult = targetObj.CompareTo(nodeValue);

				if (comparisonResult  == 0)
				{
					retObj = this;
				}
				else if (comparisonResult > 0)
				{
					if (rightNode != null)
					{
						retObj = rightNode.DepthFirstSearch(targetObj);
					}
				}
				else if (comparisonResult < 0)
				{
					if (leftNode != null)
					{
						retObj = leftNode.DepthFirstSearch(targetObj);
					}
				}

				return (retObj);
			}

			public void PrintDepthFirst()
			{
				if (leftNode != null)
				{
					leftNode.PrintDepthFirst();
				}

				Console.WriteLine(this.nodeValue.ToString());

				try
				{
					Console.WriteLine("\tZawiera lewy: " + 
						leftNode.nodeValue.ToString());
				}
				catch
				{
                    Console.WriteLine("\tZawiera lewy:  NULL");
				}
				try
				{
                    Console.WriteLine("\tZawiera prawy: " + 
						rightNode.nodeValue.ToString());
				}
				catch
				{
					Console.WriteLine("\tZawiera prawy: NULL");
				}

				if (rightNode != null)
				{
					rightNode.PrintDepthFirst();
				}
			}

			public void RemoveLeftNode()
			{
				leftNode = null;
			}

			public void RemoveRightNode()
			{
				rightNode = null;
			}
		}
		#endregion

		#region 11.7 Tworzenie drzew N-Arnych
		public static void TestNTree()
		{
			NTree<string> topLevel = new NTree<string>(3);
			NTreeNodeFactory<string> nodeFactory = new NTreeNodeFactory<string>(topLevel);

			NTreeNodeFactory<string>.NTreeNode<string> one = nodeFactory.CreateNode("Jeden");
			NTreeNodeFactory<string>.NTreeNode<string> two = nodeFactory.CreateNode("Dwa");
			NTreeNodeFactory<string>.NTreeNode<string> three = nodeFactory.CreateNode("Trzy");
			NTreeNodeFactory<string>.NTreeNode<string> four = nodeFactory.CreateNode("Cztery");
			NTreeNodeFactory<string>.NTreeNode<string> five = nodeFactory.CreateNode("Pi");
			NTreeNodeFactory<string>.NTreeNode<string> six = nodeFactory.CreateNode("Sze");
			NTreeNodeFactory<string>.NTreeNode<string> seven = nodeFactory.CreateNode("Siedem");
			NTreeNodeFactory<string>.NTreeNode<string> eight = nodeFactory.CreateNode("Osiem");
			NTreeNodeFactory<string>.NTreeNode<string> nine = nodeFactory.CreateNode("Dziewi");

			topLevel.AddRoot(one);
			Console.WriteLine("topLevel.GetRoot().CountChildren: " + 
				topLevel.GetRoot().CountChildren());

			topLevel.GetRoot().AddNode(two);
			topLevel.GetRoot().AddNode(three);
			topLevel.GetRoot().AddNode(four);

			topLevel.GetRoot().Children[0].AddNode(five);
			topLevel.GetRoot().Children[0].AddNode(eight);
			topLevel.GetRoot().Children[0].AddNode(nine);
			topLevel.GetRoot().Children[1].AddNode(six);
			topLevel.GetRoot().Children[1].Children[0].AddNode(seven);

            Console.WriteLine("Wywietlenie caego drzewa:");
			topLevel.GetRoot().PrintDepthFirst();

            Console.WriteLine("Wywietlenie drzewa od wza [dwa]:");
			topLevel.GetRoot().Children[0].PrintDepthFirst();

            Console.WriteLine("Wyszukiwanie w gb:");
			Console.WriteLine("topLevel.DepthFirstSearch(Jeden): " + 
				topLevel.GetRoot().DepthFirstSearch("Jeden").Value().ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(Dwa): " + 
				topLevel.GetRoot().DepthFirstSearch("Dwa").Value().ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(Trzy): " + 
				topLevel.GetRoot().DepthFirstSearch("Trzy").Value().ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(Cztery): " + 
				topLevel.GetRoot().DepthFirstSearch("Cztery").Value().ToString());
			Console.WriteLine("topLevel.DepthFirstSearch(Pi): " + 
				topLevel.GetRoot().DepthFirstSearch("Pi").Value().ToString());

            Console.WriteLine("\r\n\r\nWyszukiwanie wszerz:");
			Console.WriteLine("topLevel.BreadthFirstSearch(Jeden): " + 
				topLevel.GetRoot().BreadthFirstSearch("Jeden").Value().ToString());
			Console.WriteLine("topLevel.BreadthFirstSearch(Dwa): " + 
				topLevel.GetRoot().BreadthFirstSearch("Dwa").Value().ToString());
			Console.WriteLine("topLevel.BreadthFirstSearch(Trzy): " + 
				topLevel.GetRoot().BreadthFirstSearch("Trzy").Value().ToString());
			Console.WriteLine("topLevel.BreadthFirstSearch(Cztery): " + 
				topLevel.GetRoot().BreadthFirstSearch("Cztery").Value().ToString());
		}
/*
topLevel.GetRoot().CountChildren: 0
Wywietlenie caego drzewa:
this: Jeden
	childNodes[0]:  Dwa
	childNodes[1]:  Trzy
	childNodes[2]:  Cztery
this: Dwa
	childNodes[0]:  Pi
	childNodes[1]:  Osiem
	childNodes[2]:  Dziewi
this: Pi
	childNodes[0]:  NULL
	childNodes[1]:  NULL
	childNodes[2]:  NULL
this: Osiem
	childNodes[0]:  NULL
	childNodes[1]:  NULL
	childNodes[2]:  NULL
this: Dziewi
	childNodes[0]:  NULL
	childNodes[1]:  NULL
	childNodes[2]:  NULL
this: Trzy
	childNodes[0]:  Sze
	childNodes[1]:  NULL
	childNodes[2]:  NULL
this: Sze
	childNodes[0]:  Siedem
	childNodes[1]:  NULL
	childNodes[2]:  NULL
this: Siedem
	childNodes[0]:  NULL
	childNodes[1]:  NULL
	childNodes[2]:  NULL
this: Cztery
	childNodes[0]:  NULL
	childNodes[1]:  NULL
	childNodes[2]:  NULL
Wywietlenie drzewa od wza [dwa]:
this: Dwa
	childNodes[0]:  Pi
	childNodes[1]:  Osiem
	childNodes[2]:  Dziewi
this: Pi
	childNodes[0]:  NULL
	childNodes[1]:  NULL
	childNodes[2]:  NULL
this: Osiem
	childNodes[0]:  NULL
	childNodes[1]:  NULL
	childNodes[2]:  NULL
this: Dziewi
	childNodes[0]:  NULL
	childNodes[1]:  NULL
	childNodes[2]:  NULL
Wyszukiwanie wgb:
topLevel.DepthFirstSearch(Jeden): Jeden
topLevel.DepthFirstSearch(Dwa): Dwa
topLevel.DepthFirstSearch(Trzy): Trzy
topLevel.DepthFirstSearch(Cztery): Cztery
topLevel.DepthFirstSearch(Pi): Pi


Wyszukiwanie wszerz:
topLevel.BreadthFirstSearch(Jeden): Jeden
topLevel.BreadthFirstSearch(Dwa): Dwa
topLevel.BreadthFirstSearch(Trzy): Trzy
topLevel.BreadthFirstSearch(Cztery): Cztery
*/


		public class NTree<T>
			where T : IComparable<T>
		{
			public NTree() 
			{
				maxChildren = int.MaxValue;
			}

			public NTree(int maxNumChildren) 
			{
				maxChildren = maxNumChildren;
			}


			// Korze drzewa
			protected NTreeNodeFactory<T>.NTreeNode<T> root = null;
            // Maksymalna liczba wzw potomnych, ktre mog by zapisane w wle nadrzdnym
			protected int maxChildren = 0;


			public void AddRoot(NTreeNodeFactory<T>.NTreeNode<T> node)
			{
				root = node;
			}

			public NTreeNodeFactory<T>.NTreeNode<T> GetRoot()
			{
				return (root);
			}

			public int MaxChildren
			{
				get {return (maxChildren);}
			}
		}

		public class NTreeNodeFactory<T>
			where T : IComparable<T>
		{
			public NTreeNodeFactory(NTree<T> root) 
			{
				maxChildren = root.MaxChildren;
			}


			private int maxChildren = 0;


			public int MaxChildren
			{
				get {return (maxChildren);}
			}

			public NTreeNode<T> CreateNode(T value)
			{
				return (new NTreeNode<T>(value, maxChildren));
			}


			// Zagniedona klasa wza
			public class NTreeNode<U>
				where U : IComparable<U>
			{
				public NTreeNode(U value, int maxChildren) 
				{
					if (!value.Equals(null))
					{
						nodeValue = value;
					}

					childNodes = new NTreeNode<U>[maxChildren];
				}


				protected U nodeValue = default(U);
				protected NTreeNode<U>[] childNodes = null;


				public int NumOfChildren
				{
					get {return (CountChildren());}
				}

				public int CountChildren()
				{
					int currCount = 0;

					for (int index = 0; index <= childNodes.GetUpperBound(0); index++)
					{
						if (childNodes[index] != null)
						{
							++currCount;
							currCount += childNodes[index].CountChildren();
						}
					}

					return (currCount);
				}

				public int CountImmediateChildren()
				{
					int currCount = 0;

					for (int index = 0; index <= childNodes.GetUpperBound(0); index++)
					{
						if (childNodes[index] != null)
						{
							++currCount;
						}
					}

					return (currCount);
				}


				public NTreeNode<U>[] Children
				{
					get {return (childNodes);}
				}

				public NTreeNode<U> GetChild(int index)
				{
					return (childNodes[index]);
				}

				public U Value()
				{
					return (nodeValue);
				}

				public void AddNode(NTreeNode<U> node)
				{
					int numOfNonNullNodes = CountImmediateChildren();

					if (numOfNonNullNodes < childNodes.Length)
					{
						childNodes[numOfNonNullNodes] = node;
					}
					else
					{
                        throw (new Exception("Nie mona doda wicej wzw potomnych do tego wza."));
					}
				}

				public NTreeNode<U> DepthFirstSearch(U targetObj)
				{
					NTreeNode<U> retObj = default(NTreeNode<U>);

					if (targetObj.CompareTo(nodeValue) == 0)
					{
						retObj = this;
					}
					else
					{
						for (int index=0; index<=childNodes.GetUpperBound(0); index++)
						{
							if (childNodes[index] != null)
							{
								retObj = childNodes[index].DepthFirstSearch(targetObj);
								if (retObj != null)
								{
									break;
								}
							}
						}
					}

					return (retObj);
				}

				public NTreeNode<U> BreadthFirstSearch(U targetObj)
				{
					Queue<NTreeNode<U>> row = new Queue<NTreeNode<U>>();
					row.Enqueue(this);

					while (row.Count > 0)
					{
                        //  Pobranie nastpnego wza z kolejki.
						NTreeNode<U> currentNode = row.Dequeue();

                        // Czy to jest wze, ktrego szukamy?
						if (targetObj.CompareTo(currentNode.nodeValue) == 0)
						{
							return (currentNode);
						}

						for (int index = 0; 
							index < currentNode.CountImmediateChildren(); 
							index++)
						{
							if (currentNode.Children[index] != null)
							{
								row.Enqueue(currentNode.Children[index]);
							}
						}
					}

					return (null);
				}

				public void PrintDepthFirst()
				{
					Console.WriteLine("this: " + nodeValue.ToString());

					for (int index = 0; index < childNodes.Length; index++)
					{
						if (childNodes[index] != null)
						{
							Console.WriteLine("\tchildNodes[" + index + "]:  " + 
								childNodes[index].nodeValue.ToString());
						}
						else
						{
							Console.WriteLine("\tchildNodes[" + index + "]:  NULL");
						}
					}

					for (int index = 0; index < childNodes.Length; index++)
					{
						if (childNodes[index] != null)
						{
							childNodes[index].PrintDepthFirst();
						}
					}
				}

				public void RemoveNode(int index)
				{
                    //  Usunicie wza z tablicy i scalenie jej.
					if (index < childNodes.GetLowerBound(0) || 
						index > childNodes.GetUpperBound(0))
					{
						throw (new ArgumentOutOfRangeException("index", index,
                            "Indeks tablicy poza zakresem."));
					}
					else if (index < childNodes.GetUpperBound(0))
					{
						Array.Copy(childNodes, index + 1, childNodes, index, 
							childNodes.Length - index - 1);
					}

					childNodes.SetValue(null, childNodes.GetUpperBound(0));
				}
			}
		}
		#endregion

        #region 11.8 Tworzenie obiektu Set
        public static void TestSet()
		{
			Set<int> set1 = new Set<int>();
			Set<int> set2 = new Set<int>();
			Set<int> set3 = new Set<int>();

			set1.Add(1);
			set1.Add(2);
			set1.Add(3);
			set1.Add(4);
			set1.Add(5);
			set1.Add(6);

			set2.Add(-10);
			set2.Add(2);
			set2.Add(40);

			set3.Add(3);
			set3.Add(6);

			foreach (int o in set2)
			{
				Console.WriteLine(o.ToString());
			}

			Console.WriteLine("set1.Contains(2): " + set1.Contains(2));
			Console.WriteLine("set1.Contains(0): " + set1.Contains(0));

			Console.WriteLine("\r\nset1.Count: " + set1.Count);
			Console.WriteLine();
			Console.WriteLine("set1.DisplaySet: " + set1.DisplaySet());
			Console.WriteLine("set2.DisplaySet: " + set2.DisplaySet());
			Console.WriteLine("set3.DisplaySet: " + set3.DisplaySet());
			Console.WriteLine();
			Console.WriteLine("set1.UnionOf(set2): " + 
				set1.UnionOf(set2).DisplaySet());
			Console.WriteLine("set1.IntersectionOf(set2): " + 
				set1.IntersectionOf(set2).DisplaySet());
			Console.WriteLine("set1.DifferenceOf(set2): " + 
				set1.DifferenceOf(set2).DisplaySet());
			Console.WriteLine("set1 | set2: " + (set1 | set2).DisplaySet());
			Console.WriteLine("set1 & set2: " + (set1 & set2).DisplaySet());
			Console.WriteLine("set1 ^ set2: " + (set1 ^ set2).DisplaySet());
			Console.WriteLine("set1.Equals(set2): " + set1.Equals(set2));
			Console.WriteLine("set1 == set2: " + (set1 == set2));
			Console.WriteLine("set1 != set2: " + (set1 != set2));
			Console.WriteLine("set1.IsSubsetOf(set2): " + set1.IsSubsetOf(set2));
			Console.WriteLine("set1.IsSupersetOf(set2): " + set1.IsSupersetOf(set2));
			Console.WriteLine();
			Console.WriteLine("set2.UnionOf(set1): " + 
				set2.UnionOf(set1).DisplaySet());
			Console.WriteLine("set2.IntersectionOf(set1): " + 
				set2.IntersectionOf(set1).DisplaySet());
			Console.WriteLine("set2.DifferenceOf(set1): " + 
				set2.DifferenceOf(set1).DisplaySet());
			Console.WriteLine("set2.Equals(set1): " + set2.Equals(set1));
			Console.WriteLine("set2 == set1): " + (set2 == set1));
			Console.WriteLine("set2 != set1): " + (set2 != set1));
			Console.WriteLine("set2.IsSubsetOf(set1): " + set2.IsSubsetOf(set1));
			Console.WriteLine("set2.IsSupersetOf(set1): " + set2.IsSupersetOf(set1));
			Console.WriteLine();
			Console.WriteLine("set3.UnionOf(set1): " + 
				set3.UnionOf(set1).DisplaySet());
			Console.WriteLine("set3.IntersectionOf(set1): " + 
				set3.IntersectionOf(set1).DisplaySet());
			Console.WriteLine("set3.DifferenceOf(set1): " + 
				set3.DifferenceOf(set1).DisplaySet());
			Console.WriteLine("set3.Equals(set1): " + set3.Equals(set1));
			Console.WriteLine("set3 == set1: " + (set3 == set1));
			Console.WriteLine("set3 != set1: " + (set3 != set1));
			Console.WriteLine("set3.IsSubsetOf(set1): " + set3.IsSubsetOf(set1));
			Console.WriteLine("set3.IsSupersetOf(set1): " + set3.IsSupersetOf(set1));
			Console.WriteLine("set1.IsSubsetOf(set3): " + set1.IsSubsetOf(set3));
			Console.WriteLine("set1.IsSupersetOf(set3): " + set1.IsSupersetOf(set3));
			Console.WriteLine();
			Console.WriteLine("set3.UnionOf(set2): " + 
				set3.UnionOf(set2).DisplaySet());
			Console.WriteLine("set3.IntersectionOf(set2): " + 
				set3.IntersectionOf(set2).DisplaySet());
			Console.WriteLine("set3.DifferenceOf(set2): " + 
				set3.DifferenceOf(set2).DisplaySet());
			Console.WriteLine("set3 | set2: " + (set3 | set2).DisplaySet());
			Console.WriteLine("set3 & set2: " + (set3 & set2).DisplaySet());
			Console.WriteLine("set3 ^ set2: " + (set3 ^ set2).DisplaySet());
			Console.WriteLine("set3.Equals(set2): " + set3.Equals(set2));
			Console.WriteLine("set3 == set2: " + (set3 == set2));
			Console.WriteLine("set3 != set2: " + (set3 != set2));
			Console.WriteLine("set3.IsSubsetOf(set2): " + set3.IsSubsetOf(set2));
			Console.WriteLine("set3.IsSupersetOf(set2): " + set3.IsSupersetOf(set2));
			Console.WriteLine();
			Console.WriteLine("set3.Equals(set3): " + set3.Equals(set3));
			Console.WriteLine("set3 == set3: " + (set3 == set3));
			Console.WriteLine("set3 != set3: " + (set3 != set3));
			Console.WriteLine("set3.IsSubsetOf(set3): " + set3.IsSubsetOf(set3));
			Console.WriteLine("set3.IsSupersetOf(set3): " + set3.IsSupersetOf(set3));

			Console.WriteLine("set1[1]: " + set1[1].ToString());
			set1[1] = 100;

			set1.RemoveAt(1);
			set1.RemoveAt(2);
			Console.WriteLine("set1: " + set1.DisplaySet());
		}
/*  DANE POCZTKOWE
-10
2
40
set1.Contains(2): True
set1.Contains(0): False

set1.Count: 6

set1.DisplaySet: { 1, 2, 3, 4, 5, 6 }
set2.DisplaySet: { -10, 2, 40 }
set3.DisplaySet: { 3, 6 }

set1.UnionOf(set2): { 1, 2, 3, 4, 5, 6, -10, 40 }
set1.IntersectionOf(set2): { 2 }
set1.DifferenceOf(set2): { -10, 40, 1, 3, 4, 5, 6 }
set1 | set2: { 1, 2, 3, 4, 5, 6, -10, 40 }
set1 & set2: { 2 }
set1 ^ set2: { -10, 40, 1, 3, 4, 5, 6 }
set1.Equals(set2): False
set1 == set2: False
set1 != set2: True
set1.IsSubsetOf(set2): False
set1.IsSupersetOf(set2): False

set2.UnionOf(set1): { 1, 2, 3, 4, 5, 6, -10, 40 }
set2.IntersectionOf(set1): { 2 }
set2.DifferenceOf(set1): { 1, 3, 4, 5, 6, -10, 40 }
set2.Equals(set1): False
set2 == set1): False
set2 != set1): True
set2.IsSubsetOf(set1): False
set2.IsSupersetOf(set1): False

set3.UnionOf(set1): { 1, 2, 3, 4, 5, 6 }
set3.IntersectionOf(set1): { 3, 6 }
set3.DifferenceOf(set1): { 1, 2, 4, 5 }
set3.Equals(set1): False
set3 == set1: False
set3 != set1: True
set3.IsSubsetOf(set1): True
set3.IsSupersetOf(set1): False
set1.IsSubsetOf(set3): False
set1.IsSupersetOf(set3): True

set3.UnionOf(set2): { -10, 2, 40, 3, 6 }
set3.IntersectionOf(set2): {}
set3.DifferenceOf(set2): { -10, 2, 40, 3, 6 }
set3 | set2: { -10, 2, 40, 3, 6 }
set3 & set2: {}
set3 ^ set2: { -10, 2, 40, 3, 6 }
set3.Equals(set2): False
set3 == set2: False
set3 != set2: True
set3.IsSubsetOf(set2): False
set3.IsSupersetOf(set2): False

set3.Equals(set3): True
set3 == set3: True
set3 != set3: False
set3.IsSubsetOf(set3): True
set3.IsSupersetOf(set3): True
set1[1]: 2
set1: { 1, 3, 5, 6 }
*/


		public class Set<T>
		{
			private List<T> internalSet = new List<T>();

			public int Count
			{
				get {return (internalSet.Count);}
			}

			public T this[int index] 
			{
				get 
				{
					return (internalSet[index]);
				}
				set 
				{
					if (internalSet.Contains(value))
					{
						throw (new ArgumentException(
                               "Do zbioru nie mona dodawa duplikatw."));
					}
					else
					{
						internalSet[index] = value;
					}
				}
			}

			public void Add(T obj)
			{
				if (internalSet.Contains(obj))
				{
					throw (new ArgumentException(
                           "Do zbioru nie mona dodawa duplikatw."));
				}
				else
				{
					internalSet.Add(obj);
				}
			}

			public void Remove(T obj)
			{
				if (internalSet.Contains(obj))
				{
                    throw (new ArgumentException("Nie mona usun obiektu ze zbioru " +
                   "poniewa go w nim nie ma."));
				}
				else
				{
					internalSet.Remove(obj);
				}
			}

			public void RemoveAt(int index)
			{
				internalSet.RemoveAt(index);
			}

			public bool Contains(T obj)
			{
				return (internalSet.Contains(obj));
			}

			public static Set<T> operator |(Set<T> lhs, Set<T> rhs)
			{
				return (lhs.UnionOf(rhs));
			}

			public Set<T> UnionOf(Set<T> set) 
			{
				Set<T> unionSet = new Set<T>();
				Set<T> sourceSet = null;
				Set<T> mergeSet = null;

				if (set.Count > this.Count)   // Optymalizacja
				{
					sourceSet = set;
					mergeSet = this;
				}
				else
				{
					sourceSet = this;
					mergeSet = set;
				}

                // Inicjalizacja obiektu unionSet danymi z obiektu SourceSet.
				for (int index = 0; index < sourceSet.Count; index++)
				{
					unionSet.Add(sourceSet.internalSet[index]);
				}

				// mergeSet OR sourceSet
				for (int index = 0; index < mergeSet.Count; index++)
				{
					if (!sourceSet.Contains(mergeSet.internalSet[index])) 
					{
						unionSet.Add(mergeSet.internalSet[index]);
					}
				}

				return (unionSet);
			}

			public static Set<T> operator &(Set<T> lhs, Set<T> rhs)
			{
				return (lhs.IntersectionOf(rhs));
			}

			public Set<T> IntersectionOf(Set<T> set)
			{
				Set<T> intersectionSet = new Set<T>();
				Set<T> sourceSet = null;
				Set<T> mergeSet = null;

				if (set.Count > this.Count)   // Optymalizacja
				{
					sourceSet = set;
					mergeSet = this;
				}
				else
				{
					sourceSet = this;
					mergeSet = set;
				}

				// mergeSet AND sourceSet
				for (int index = 0; index < mergeSet.Count; index++)
				{
					if (sourceSet.Contains(mergeSet.internalSet[index])) 
					{
						intersectionSet.Add(mergeSet.internalSet[index]);
					}
				}

				return (intersectionSet);
			}

			public static Set<T> operator ^(Set<T> lhs, Set<T> rhs)
			{
				return (lhs.DifferenceOf(rhs));
			}

			public Set<T> DifferenceOf(Set<T> set)
			{
				Set<T> differenceSet = new Set<T>();

				// mergeSet XOR sourceSet
				for (int index = 0; index < set.Count; index++)
				{
					if (!this.Contains(set.internalSet[index])) 
					{
						differenceSet.Add(set.internalSet[index]);
					}
				}

				for (int index = 0; index < this.Count; index++)
				{
					if (!set.Contains(internalSet[index])) 
					{
						differenceSet.Add(internalSet[index]);
					}
				}

				return (differenceSet);
			}

			public static bool operator ==(Set<T> lhs, Set<T> rhs)
			{
				return (lhs.Equals(rhs));
			}

			public static bool operator !=(Set<T> lhs, Set<T> rhs)
			{
				return (!lhs.Equals(rhs));
			}

			public override bool Equals(object obj)
			{
				// Poniewa przeciamy metod Equals, musimy wykorzysta t sam sygnatur (tzn. typ obiektowy)
				bool isEquals = false;

				if (obj != null)
				{
					if (obj is Set<T>)
					{
						if (this.Count == ((Set<T>)obj).Count)
						{
							if (this.IsSubsetOf((Set<T>)obj) && 
								((Set<T>)obj).IsSubsetOf(this))
							{
								isEquals = true;
							}
						}
					}
				}

				return (isEquals);
			}

			public override int GetHashCode()
			{
				return (internalSet.GetHashCode());
			}

			public bool IsSubsetOf(Set<T> set)
			{
				for (int index = 0; index < this.Count; index++)
				{
					if (!set.Contains(internalSet[index])) 
					{
						return (false);
					}
				}

				return (true);
			}

			public bool IsSupersetOf(Set<T> set)
			{
				for (int index = 0; index < set.Count; index++)
				{
					if (!this.Contains(set.internalSet[index])) 
					{
						return (false);
					}
				}

				return (true);
			}

			public string DisplaySet()
			{
				if (this.Count == 0)
				{
					return ("{}");
				}
				else
				{
					StringBuilder displayStr = new StringBuilder("{ ");

					for (int index = 0; index < (this.Count - 1); index++)
					{
						displayStr.Append(internalSet[index]);
						displayStr.Append(", ");
					}

					displayStr.Append(internalSet[internalSet.Count - 1]);
					displayStr.Append(" }");

					return (displayStr.ToString());
				}
			}

			public IEnumerator<T> GetEnumerator()
			{
				for (int cntr = 0; cntr < internalSet.Count; cntr++)
				{
					yield return (internalSet[cntr]);
				}
			}
			
			
			//public IEnumerator GetEnumerator()
			//{
			//    return(new SetEnumerator(this));
			//}
			//
			//
			//// Zagniedona klasa enumeratora
			//public class SetEnumerator : IEnumerator
			//{
			//    public SetEnumerator(Set theSet)
			//    {
			//        setObj = theSet;
			//    }
			//    private Set setObj;
			//    private int index = -1;
			//    public bool MoveNext()
			//    {
			//        index++;
			//        if (index >= setObj.Count)
			//        {
			//            return(false);
			//        }
			//        else
			//        {
			//            return(true);
			//        }
			//    }
			//    public void Reset()
			//    {
			//        index = -1;
			//    }
			//    public object Current
			//    {
			//        get{return(setObj[index]);}
			//    }
			//}
		}

		#endregion
	}
}
